<?php
namespace MultibankSpace\Admin\Installer\Importer;

use MultibankSpace\Admin\Installer\Importer\ACF;
use MultibankSpace\Admin\Installer\Importer\CPTUI;
use MultibankSpace\Admin\Installer\Importer\Elementor_Fonts;
use MultibankSpace\Admin\Installer\Importer\Elementor_Icons;
use MultibankSpace\Admin\Installer\Importer\Elementor_Importer;
use MultibankSpace\Admin\Installer\Importer\Elementor_Kit;
use MultibankSpace\Admin\Installer\Importer\Elementor_Templates;
use MultibankSpace\Admin\Installer\Importer\Theme_Options;
use MultibankSpace\Admin\Installer\Importer\WPForms;
use MultibankSpace\Admin\Installer\Importer\Forminator;
use MultibankSpace\Admin\Installer\Importer\Give_WP;
use MultibankSpace\Admin\Installer\Importer\WPRM_Templates;
use MultibankSpace\Admin\Installer\Importer\Woo_Product_Filter;
use MultibankSpace\Core\Utils\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Importer handler class is responsible for different methods on importing plugins settings.
 */
class Importer {

	/**
	 * Importer constructor.
	 */
	public function __construct() {
		new Theme_Options();

		new ACF();

		new CPTUI();

		new WPForms();

		new Forminator();

		new Give_WP();

		new Woo_Product_Filter();

		new WPRM_Templates();

		new Elementor_Fonts();

		new Elementor_Icons();

		new Elementor_Kit();

		new Elementor_Templates();

		new Elementor_Importer();

		add_action( 'cmsmasters_wp_import_insert_attachment', array( $this, 'set_import_attachments_ids' ), 10, 4 );

		add_action( 'wp_import_insert_post', array( $this, 'set_import_posts_ids' ), 10, 4 );

		add_action( 'wp_import_insert_term', array( $this, 'set_import_terms_ids' ), 10, 2 );
	}

	/**
	 * Set import attachments ids.
	 *
	 * @param int $post_id Post id.
	 * @param int $original_id Post original id.
	 * @param array $postdata Post data.
	 * @param array $data Data.
	 */
	public function set_import_attachments_ids( $post_id, $original_id, $postdata, $data ) {
		$demo = Utils::get_demo();

		$attachments_ids = get_transient( "cmsmasters_multibank_{$demo}_import_attachments_ids" );

		if ( false === $attachments_ids ) {
			$attachments_ids = array();
		}

		if ( ! is_wp_error( $post_id ) && is_numeric( $post_id ) ) {
			$attachments_ids[ $original_id ] = $post_id;
		}

		set_transient( "cmsmasters_multibank_{$demo}_import_attachments_ids", $attachments_ids, HOUR_IN_SECONDS );
	}

	/**
	 * Set import posts ids.
	 *
	 * @param int $post_id Post id.
	 * @param int $original_id Post original id.
	 * @param array $postdata Post data.
	 * @param array $post The Post.
	 */
	public function set_import_posts_ids( $post_id, $original_id, $postdata, $post ) {
		$demo = Utils::get_demo();

		$displayed_ids = get_transient( "cmsmasters_multibank_{$demo}_import_displayed_ids" );

		if ( false === $displayed_ids ) {
			$displayed_ids = array();
		}

		$displayed_ids['post_id'][ $post['post_type'] ][ $original_id ] = $post_id;

		set_transient( "cmsmasters_multibank_{$demo}_import_displayed_ids", $displayed_ids, HOUR_IN_SECONDS );
	}

	/**
	 * Set import terms ids.
	 *
	 * @param int $term_id Term id.
	 * @param array $data Term data.
	 */
	public function set_import_terms_ids( $term_id, $data ) {
		$demo = Utils::get_demo();

		$displayed_ids = get_transient( "cmsmasters_multibank_{$demo}_import_displayed_ids" );

		if ( false === $displayed_ids ) {
			$displayed_ids = array();
		}

		if ( ! isset( $data['taxonomy'] ) || ! isset( $data['id'] ) ) {
			return;
		}

		$displayed_ids['taxonomy'][ $data['taxonomy'] ][ $data['id'] ] = $term_id;

		set_transient( "cmsmasters_multibank_{$demo}_import_displayed_ids", $displayed_ids, HOUR_IN_SECONDS );
	}

}
